<?php
/*--------------------------------------------------------------
   Visualization.php 2021-10-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use Webmozart\Assert\Assert;

class Visualization
{
    const AREA_CHART = "areaChart";
    
    const BAR_CHART = "barChart";
    
    const PIE_CHART = "pieChart";
    
    const STACKED_COLUMNS_CHART = "stackedColumnsChart";
    
    const TABLE = "table";
    
    const TEXT = "text";
    
    const TREEMAP_CHART = "treemapChart";
    
    const DONUT_CHART = "donutChart";
    
    const RADIAL_BAR_CHART = "radialBarChart";
    
    const TWO_SIDED_BAR_CHART = "twoSidedBarChart";
    
    private const VALID_VALUES = [
        self::AREA_CHART,
        self::BAR_CHART,
        self::PIE_CHART,
        self::STACKED_COLUMNS_CHART,
        self::TABLE,
        self::TEXT,
        self::TREEMAP_CHART,
        self::DONUT_CHART,
        self::RADIAL_BAR_CHART,
        self::TWO_SIDED_BAR_CHART
    ];
    
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $value)
    {
        Assert::stringNotEmpty($value);
        Assert::inArray($value, self::VALID_VALUES);
        
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $visualization): self
    {
        return new self($visualization);
    }
    
    
    /**
     * Return value.
     */
    public function value(): string
    {
        return $this->value;
    }
}